//****************************************************************
//     Top Ranking Site Search Mode Huff Model
//     AUTHOR : S. Kido      
//     Version: Scilab-5.4.1 (Mac OS-X version) 
//     Update: June 10, 2014. 
//     THE PROGRAM NAME : TopRankingSiteSearchMode-Huff-Model.sce
//****************************************************************
//////////////////////////////////////////////////////////////////////////////
function progtitle()
//title
//-------------------------------------------------------------
 mprintf('\n'); 
mprintf('_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/\n');
mprintf('_/                                                            _/\n');  
mprintf('_/        Huff Model for The Top Site Search Mode             _/\n');
mprintf('_/        Scilab-5.4.1 (Mac OS-X version)                     _/\n');
mprintf('_/        Author  :  S. Kido                                  _/\n');
mprintf('_/        Update  :  June   10, 2014.                         _/\n');
mprintf('_/        Program : TopRankingSiteSearchMode-Huff-Model.sce   _/\n');
mprintf('_/                                                            _/\n');  
mprintf('_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/\n'); 
 mprintf('\n');  
endfunction
/////////////////////////////////////////////////////////////////////////////
function initMap()
//  setiing for initial Map  
//------------------------------------------------------------------	
// for plotting residential area i=1,2,3 on the map
 x1 =[1,1,6]; //value of axis X
 y1 =[8,1,7]; //value of axis Y
//  existing stores j= A,B,C
 x2 =[2,3,6];//value of axis X
 y2 =[3,8,1]; //value of axis X
// reform to matrix DX ( coordination)
n=3;m=3;     
 for i=1:n   
   DX(i,1)=x1(i);
   DX(i,2)=y1(i);
 end
    i=0;
 for j=n+1:n+m
       i=i+1;
   DX(j,1)=x2(i);
   DX(j,2)=y2(i);
 end
 // set number of 
       x_max=ceil(max(DX))+1;
       x_min =ceil(min(DX))-1; 
       if x_max <10 then x_max=10;
       end
//      x_max=10;
//      x_min =0;
//----------------------------------------------------
        plot2d([ x_min ; x_max],[ x_min ; x_max],0);
         xset("font size",3); 
  xtitle ('Initial Map of residential area(1,2,3..) and shopping center(A,B,C..)',...
  'X axis','Y axis');xgrid();
//----------------------------------------------------
  for i = 1 : n +m     
       cx(i)=DX(i,1);
       cy(i)=DX(i,2);
   end //i
   for i=1:n
       xstring(cx(i),cy(i),ascii(48 + i),0,1);// 48 for numeric 1 2 3
   end
    j=0;
   for i=n+1:n+m
       j=j+1;
        xstring(cx(i),cy(i),ascii(64 + j),0,1);//64 for alpabet ABC,96 for abc 
    coordx(j)=cx(i);
    coordy(j)=cy(i);
   end

 endfunction //initMap
//=========================================================================
function initMap2()
//  setiing for initial Map  
//------------------------------------------------------------------	
// for plotting residential area i=1,2,3 on the map
 x1 =[1,1,6]; //value of axis X
 y1 =[8,1,7]; //value of axis Y
//  existing stores j= A,B,C
 x2 =[2,3,6];//value of axis X
 y2 =[3,8,1]; //value of axis X
// reform to matrix DX ( coordination)
n=3;m=3;     
 for i=1:n   
   DX(i,1)=x1(i);
   DX(i,2)=y1(i);
 end
    i=0;
 for j=n+1:n+m
       i=i+1;
   DX(j,1)=x2(i);
   DX(j,2)=y2(i);
 end
      x_max=ceil(max(DX))+1;
      x_min =ceil(min(DX))-1; 
      if x_max <10 then x_max=10;
       end
//      x_max=10;
//     x_min =0;
//----------------------------------------------------
//        plot2d([ x_min ; x_max],[ x_min ; x_max],0);
//         xset("font size",3); 
//  xtitle ('Initial Map of residential area(1,2,3..) and shopping center(A,B,C..)',...
//  'X axis','Y axis');xgrid();
//----------------------------------------------------
  for i = 1 : n +m     
       cx(i)=DX(i,1);
       cy(i)=DX(i,2);
   end //i
   for i=1:n
       xstring(cx(i),cy(i),ascii(48 + i),0,1);// 48 for numeric 1 2 3
   end
    j=0;
   for i=n+1:n+m
       j=j+1;
        xstring(cx(i),cy(i),ascii(64 + j),0,1);//64 for alpabet ABC,96 for abc 
    coordx(j)=cx(i);
    coordy(j)=cy(i);
   end

endfunction //initMap2
/////////////////////////////////////////////////////////////////////////////// 
////////////////////////////////////////////////////////////////////// 
function [n,m,lmd,pop,Sj,x1,y1,x2,y2 ]=setDATA(SSj)
//------------------------------------------------------------------	
//   Initial set of the data  　  
//------------------------------------------------------------------  
m=4;         //   No. of Store (candidate locations) 
n=3;         //   No. of residetial area 
lmd=2;       //  parameter λ 
// population of area
pop(1)=1500;  // 1
pop(2)=1000;  // 2
pop(3)=3000;  // 3
//  
//  attractiveness (square footage) of existing stores(shopping center) 
Sj(1) =1500;  // A
Sj(2) =2500;  // B
Sj(3) =3000;  // C
// D: candidate of (new)store :change this value in this site search mode.
//Sj(4) =1000;  
Sj(4) =SSj; 
//-------------------------location data(coordinate on mesh)------------------
//---------------------------
// Location   Coordinate(x,y)
//---------------------------
// 1           ( 1, 8)
// 2           ( 1, 1)
// 3           ( 6, 7)
// A           ( 2, 3)
// B           ( 3, 8)
// C           ( 6, 1)
//
// for plotting on the graphmap
// residential area i=1,2,3
x1 =[1,1,6]; //value of axis X
y1 =[8,1,7]; //value of axis Y
//  existing stores j= A,B,C
 x2 =[2,3,6 ];//value of axis X
 y2 =[3,8,1 ]; //value of axis X
endfunction
///////////////////////////////////////////////////////////////////////////
function [x1,y1,x2,y2,Sj]=inpAddStoreData (x1,y1,x2,y2,Sj,m)
// input Coordinates and footage of Candidate Store 
//------------------------------------------------------------------
mprintf('\n\n\n\n'); 
 mprintf('Enter Coordinates of Candidate Store  :\n');
   x2(m)= input(' X2 = ');
   y2(m)= input(' Y2 = '); 
//------------------------------------------------------------------    
 mprintf('Enter Attractiveness of the candidate store :\n');
   Sj(m) = input('Sq. Footage of the store = '); 
  mprintf('\n\n\n\n'); 
//
endfunction //inpAddData
///////////////////////////////////////////////////////////////////////////
 function [x1,y1,x2,y2,Sj]=inputCd (x1,y1,x2,y2,Sj,jj,ii,m)
// Feed Coordinates for search mode
//------------------------------------------------------------------
   x2(m) = ii;
   y2(m) = jj; 
 //  Sj(m) = 2000; 
//
endfunction //inputCd
///////////////////////////////////////////////////////////////////////
function [DX]=compDX(n,m,x1,x2,y1,y2)
//-------------------------------------------------------------------
// transform  to data matrix from coordinates
//
nm=n+m;
for i=1:n   
DX(i,1)=x1(i);
DX(i,2)=y1(i);
end
    i=0;
   for j=n+1:nm
       i=i+1;
    DX(j,1)=x2(i);
    DX(j,2)=y2(i);
end
endfunction // compDX
//-------------------------------------------------------------------
////////////////////////////////////////////////////////////////////
function [cx,cy,coordx,coordy]=plotfuncDATA1 (n,m,x1,x2,y1,y2,DX,caseNum)
// for plotting on the graphmap
//---------------------------------------------------------------------
//
       x_max=ceil(max(DX))+1;
       x_min =ceil(min(DX))-1; 
       if x_max <10 then x_max=10;
       end
//      x_max=10;
//      x_min =0;
//----------------------------------------------------
        plot2d([ x_min ; x_max],[ x_min ; x_max],0);
         xset("font size",3); 
  xtitle ('Zone-Plot of residential area(1,2,3..) and shopping center(A,B,C..)',...
  'X axis','Y axis');xgrid();
//----------------------------------------------------
nm=n+m;
  for i = 1 : nm     
       cx(i)=DX(i,1);
       cy(i)=DX(i,2);
   end //i
   for i=1:n
       xstring(cx(i),cy(i),ascii(48 + i),0,1);// 48 for numeric 1 2 3
   end
    j=0;
   for i=n+1:nm
       j=j+1;
    coordx(j)=cx(i);
    coordy(j)=cy(i);
   end
   //
   j=0;
   for i=n+1:nm-1
       j=j+1;
        xstring(cx(i),cy(i),ascii(64 + j),0,1);//64 for alpabet ABC,96 for abc
   end

   str=["Case";string(caseNum)];
   xstring(cx(nm),cy(nm),str,2,3);
///////////////////////////////////////////////////////////////////////
endfunction //plotfuncDATA1
///////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
function [crdx,crdy]=plotTop10 (DX,crdx,crdy,maxRank)
// for plotting  the top 10 sites
//---------------------------------------------------------------------
//
initMap();
//clf(1);     //clear graphic window (1)
     x_max=ceil(max(DX))+1;
     x_min =ceil(min(DX))-1; 
      if x_max <10 then x_max=10;
      end
//      x_max=10;
//      x_min =0;
//----------------------------------------------------
        plot2d([ x_min ; x_max],[ x_min ; x_max],0);
         xset("font size",2); 
  xtitle ('Sites Ranking Plot','X axis','Y axis');xgrid();
//----------------------------------------------------
for ij=1:maxRank 
    kij= k(ij);  
    Kx1=crdx(kij);
    Ky1=crdy(kij);    
   str=["Rank";string(ij)];
   xstring(Kx1,Ky1,str,2,3);
end
///////////////////////////////////////////////////////////////////////
endfunction //plotTop10
////////////////////////////////////////////////////////////////////////
function prtCoord(n,m,cx,cy)
// print coordinates    
// ------------------- ---------------------------------------------------
mprintf('   Table of Coordinates :  Case[%d]\n',caseNum);
mprintf('----------------------------------------------------------------\n');
mprintf('              Coordinates of Area(i) and Store(j)\n');
mprintf('----------------------------------------------------------------\n');
mprintf('                 Location   Coordinate(x,y)\n');
mprintf('        ---------------------------------------------\n');
   for i=1:n
 mprintf('                   %c           (%2d,%2d)\n',ascii(48 + i),cx(i),cy(i)); 
   end
    j=0;
   for i=n+1:n+m
       j=j+1;
mprintf('                   %c           (%2d,%2d)\n',ascii(64 + j),cx(i),cy(i)); 
   end
mprintf('----------------------------------------------------------------\n');   
endfunction // prtCoord
///////////////////////////////////////////////////////////////////////
function [Dij]=compCityDist(n,m,x1,x2,y1,y2)
//compute city block distance
// ------------------- -----------------------------
 for  i=1:n;
   for j=1:m;
    Dij(i,j)=abs(x1(i)-x2(j))+abs(y1(i)-y2(j));
    if Dij(i,j)==0 then Dij(i,j)=1 ;mprintf(' Dij=0 occured!! \n') 
                          end
    end
  end
//
endfunction //comCityDist
/////////////////////////////////////////////////////////////////////////////
function [Pij,totali,sigT]=compPij(n,m,Sj,Dij)
// conpute probability of store sellection: Pij
//-------------------------------------------------------------
    for i=1:n 
       locT(i)=0;
        for  j=1:m                                                      
            sigT(i,j) =(Sj(j)/Dij(i,j)^2); 
            locT(i)=locT(i)+sigT(i,j);
            totali(i)=locT(i);
        end    
    end
// compute  Pij(i,j) 
//
      for i=1:n 
        for  j=1:m                                                      
            Pij(i,j)=sigT(i,j)/totali(i);    
        end 
       end
endfunction      //compPij
//////////////////////////////////////////////////////////////////////////////
function prtInputData(lmd,n,m,Sj,pop)
//		Display of Parameters
//--------------------------------------------------------------
    mprintf('   Table of Parameters :  Case[%d]\n',caseNum);
    mprintf('        ------ Parameters of Model ------\n');
    mprintf('                        λ :  %f \n',lmd);
    mprintf('          No. of Store  m :  %d \n', m);
    mprintf('          No. of Area   n :  %d \n', n);
    mprintf('        ---------------------------------\n\n\n');
/////////////////table of square footage of store(j) ///////////
       mprintf('  Table of Sj(square footage of stores): Case[%d]\n',caseNum);
       mprintf('-------------------------------------------------\n');
       mprintf('        Store(j)   Sj(j)   \n');
       mprintf('-------------------------------------------------\n');
  for j=1:m      
       mprintf('         %c         %d   \n', ascii(64 + j),Sj(j));  
  end
       mprintf('-------------------------------------------------\n');
       mprintf('\n\n');     
/////////////////////////// table of population of residential area ///////////
       mprintf('  Table of population of residential area : Case[%d]\n',caseNum);
       mprintf('-------------------------------------------------\n');
       mprintf('        Area(i)    Pop(i)   \n');
       mprintf('-------------------------------------------------\n');
  for i=1:n      
       mprintf('         %d         %d   \n', i,pop(i));  
  end
       mprintf('-------------------------------------------------\n');
endfunction //  prtInputData     
///////////////////////////////////////////////////////////////////////////////
function prtDij2(m,n,Dij)
//Table of Dij:  City Block Distance    
//--------------------------------------------------------------  
mprintf('\n\n'); 
mprintf('  Table of Dij:  City Block Distance  : Case[%d]\n',caseNum);
mprintf('----------------------------------------------------------------\n');
mprintf('  Accessibiity   Dij : Distance between  Area(i) and Store(j)\n');
mprintf('----------------------------------------------------------------\n');
mprintf('                      Area(i) \n');
mprintf('----------------------------------------------------------------\n');
mprintf(' Store(j)');
for i=1:n
    mprintf('        %c',ascii(48 + i));
end
mprintf('\n');
mprintf('----------------------------------------------------------------\n');
   for  j=1:m    
     mprintf( '  %c      ',ascii(64 + j));         
    for i=1:n 
      mprintf( '    %5.1f',Dij(i,j));
    end
    mprintf('\n');
  end
mprintf('----------------------------------------------------------------\n');
  mprintf('\n'); 
  //
endfunction //prtDij2
///////////////////////////////////////////////////////////////////////////////
function prtPij2(n,m,Pij)
// Table of Pij
//-------------------------------------------------------------
mprintf('\n\n'); 
mprintf('   Table of Pij :  Case[%d]\n',caseNum);
mprintf('----------------------------------------------------------------\n');
mprintf('   Patronage Probabilty  Pij of Area(i)  by Store(j) \n');
mprintf('----------------------------------------------------------------\n');
mprintf('                      Area(i) \n');
mprintf('----------------------------------------------------------------\n');
mprintf('Store(j)');
for i=1:n
  mprintf('        %c   ',ascii(48 + i));
end
//
mprintf('\n');
mprintf('----------------------------------------------------------------\n');
   for  j=1:m    
     mprintf( '  %c      ',ascii(64 + j));         
    for i=1:n 
      mprintf( '     %5.5f',Pij(i,j));
    end
    mprintf('\n');
   end
mprintf('----------------------------------------------------------------\n');
 mprintf('\n'); 
endfunction //prtPij2
///////////////////////////////////////////////////////////////////////////////
function [sumPOP3,sumPOP2,sumPOP,shopPOP]=prtExpPop(n,m,pop,Pij)
//expected customers of the stores
//-------------------------------------------------------------
    for i=1:n
     sumPOP(i)=0;
      for j=1:m
       shopPOP(i,j)=pop(i)*Pij(i,j);
       sumPOP(i)=sumPOP(i)+shopPOP(i,j);
      end    
    end
//
for j=1:m
    sumPOP2(j)=0;
    for i=1:n      
       sumPOP2(j)=sumPOP2(j)+shopPOP(i,j);
    end  
end
//
mprintf('\n\n'); 
mprintf('  Table of expected customers of the stores : Case[%d]\n',caseNum);
mprintf('----------------------------------------------------------------\n');
mprintf('  Expected customers from Area(i) to Store(j)\n');
mprintf('----------------------------------------------------------------\n');
mprintf('                      Area(i) \n');
mprintf('----------------------------------------------------------------\n');
mprintf(' Store(j)');
for i=1:n
  mprintf('     %c     ',ascii(48 + i));
end
mprintf('  Total');
mprintf('\n');
mprintf('----------------------------------------------------------------\n');
   for  j=1:m    
     mprintf( '  %c ',ascii(64 + j));         
    for i=1:n 
      mprintf( '    %7.0f',shopPOP(i,j));
    end
      mprintf( '    %7.0f',sumPOP2(j));
      mprintf('\n');
   end
mprintf('----------------------------------------------------------------\n');
mprintf(' Total');
    for i=1:n 
      mprintf( '  %7.0f  ',sumPOP(i));
    end
//
    sumPOP3=0;
    for j=1:m      
       sumPOP3=sumPOP3+sumPOP2(j);
    end 
    mprintf( '  %7.0f  ',sumPOP3);
    mprintf('\n'); 
mprintf('----------------------------------------------------------------\n');
//
endfunction //prtExpPop
///////////////////////////////////////////////////////////////////////////////
function[sumPOP2]= prtSummary(n,m,coordx,coordy,Sj,sumPOP2,caseNum)
//==================================================
mprintf('\n\n'); 
mprintf('   Table of Summary (1) :    Simulation Case[%d]\n',caseNum); 
mprintf('  ---------------------------------------------------\n');
mprintf('   Store(j)   Coordinate   Sj(attraction)  Total-Pop.      \n');
mprintf('  ---------------------------------------------------\n');
for j=1:m  
mprintf('    %c          (%2d,%2d)    %9.0f     %9.0f \n',ascii(64 + j),...
coordx(j),coordy(j),Sj(j),sumPOP2(j));  
end
mprintf('  ---------------------------------------------------\n');
mprintf('\n\n'); 
//
endfunction //prtSummary
///////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
 function [Sj]=inpSimStore(Sj)     
  mprintf('Enter Attractiveness of the candidate store :\n');
  Sj(4) = input('Sq. Footage of the case store = '); 
 endfunction
//------------------------------------------------------------------    
// 
//:*************************************************************************
//                     main program 
//:*************************************************************************
clear all; //clear work space
clc();     //clear cosole
clf();     //clear graphic window  
funcprot(0)
//
progtitle();
caseNum=1;
 mprintf('Simulation Start: '); 
//======================================================== 
 w=getdate();
 mprintf(" %d. %d. %d, %d:%d",w(1),w(2),w(6),w(7),w(8));  
//========================================================
 mprintf('\n\n');
//
 mprintf('ENTER Attractiveness of the planned store :\n');
   SSj = input('Sq. Footage of the store = '); 
 mprintf('\n\n'); 
 mprintf('ENTER Number of Upper Limit of Ranking to Output :\n');
   maxRank = input('No. of Ranks = '); 
 mprintf('\n\n\n\n'); 
//
ij=0;
for ii=1:10
    for jj=1:10  
        ij=ij+1;
 [n,m,lmd,pop,Sj,x1,y1,x2,y2]= setDATA();
             [x1,y1,x2,y2,Sj]=inputCd (x1,y1,x2,y2,Sj,jj,ii,m)       
                         [DX]= compDX(n,m,x1,x2,y1,y2);
     [cx,cy,coordx,coordy]= plotfuncDATA1 (n,m,x1,x2,y1,y2,DX,caseNum);
                        [Dij]= compCityDist(n,m,x1,x2,y1,y2); 
            [Pij,totali,sigT]= compPij(n,m,Sj,Dij);
[sumPOP3,sumPOP2,sumPOP,shopPOP]=prtExpPop(n,m,pop,Pij); 
                   [sumPOP2]= prtSummary(n,m,coordx,coordy,Sj,sumPOP2,caseNum);
               POPsum1(ii,jj)=sumPOP2(m);
               POPsum2(ij)   =sumPOP2(m);
               crdx(ij) = ii;
               crdy(ij) = jj;
               
  caseNum=caseNum+1;
  end
end
///////////////////// Search and Print max pop. case site ///////////////////
ij=0;
[maxPOP]=max(POPsum1); //find  max. pop. site 
//--------------------------------------------------------
mprintf('\n\n'); 
mprintf('  Table of Comparison : Sj(Sq.footage)=%d \n',Sj(m)); 
mprintf('  ---------------------------------------\n');
mprintf('   Case(k)   Coordinate    Expected-Pop. \n');
mprintf('  ---------------------------------------\n');
for ii=1:10
    for jj=1:10  
        ij=ij+1;
        if maxPOP== POPsum1(ii,jj) then
            maxCase=ij;maxCX=ii;maxCY=jj; // record max. case no. and coordinate
        end
mprintf('    %3d       (%2d,%2d)      %7.0f    \n',ij,ii,jj,POPsum1(ii,jj));
    end
end 
mprintf('  ----------------------------------------\n');
mprintf('\n\n'); 
//find max.POP site
mprintf('Max. Case: %d (%2d,%2d) Expected-Pop. =%9.0f    \n',...
maxCase,maxCX,maxCY,maxPOP); 
//
[POPsort,k] =gsort(POPsum2,'g');
 mprintf('\n\n'); 
mprintf(' Sites Ranking of Expected-Pop. : Sj(Sq.footage)=%d  \n',Sj(m)); 
mprintf('---------------------------------------------------\n');
mprintf('    Rank       Case    Coordinate     Expected-Pop.\n');
mprintf('---------------------------------------------------\n');
for ij=1:100 
    kij= k(ij);  
    Kx1=crdx(kij);
    Ky1=crdy(kij);    
mprintf('     %3d       %3d     (%2d,%2d)       %9.0f    \n',...
ij,k(ij),Kx1,Ky1,POPsort(ij));
end
mprintf('---------------------------------------------------\n\n\n');              
//
//======================================================== 
 w=getdate();
mprintf('========================================================\n');
mprintf('   The Huff Model for Top Sites Searching          \n\n'); 
mprintf("                %d. %d. %d, %d:%d",w(1),w(2),w(6),w(7),w(8));
mprintf('\n'); 
mprintf('========================================================\n'); 
mprintf('\n\n'); 
mprintf('Top%d sites of Expected-Pop.:Planned Sq.footage=%d  \n',maxRank,Sj(m)); 
mprintf('----------------------------------------------------\n');
mprintf('    Rank       Case    Coordinate     Expected-Pop. \n');
mprintf('----------------------------------------------------\n');
for ij=1:maxRank
    kij= k(ij);  
    Kx1=crdx(kij);
    Ky1=crdy(kij);    
mprintf('     %3d       %3d     (%2d,%2d)       %9.0f    \n',...
ij,k(ij),Kx1,Ky1,POPsort(ij));
end
mprintf('----------------------------------------------------\n');    
//
//function [crdx,crdy]=plotTop10 (DX,crdx,crdy,maxRank)
// for plotting  the top 10 sites
//---------------------------------------------------------------------
//
scf(1);
initMap2();
//
      x_max=ceil(max(DX))+1;
      x_min =ceil(min(DX))-1; 
       if x_max <10 then x_max=10;
       end
 //    x_max=10;
 //    x_min =0;
//----------------------------------------------------
        plot2d([ x_min ; x_max],[ x_min ; x_max],0);
         xset("font size",2); 
  xtitle ('Sites Ranking Plot','X axis','Y axis');xgrid();
//----------------------------------------------------
for ij=1:maxRank 
    kij= k(ij);  
    Kx1=crdx(kij);
    Ky1=crdy(kij);    
   str=["Rank";string(ij)];
   xstring(Kx1,Ky1,str,2,3);
end
///////////////////////////////////////////////////////////////////////
//endfunction //plotTop10
//[crdx,crdy]=plotTop10 (DX,crdx,crdy,maxRank);              
//------------------------------------- end of program ------------------------
